import org.serviio.library.metadata.*
import org.serviio.library.online.*

/** Snotr.com content URL extractor plugin.
 *
 * Based on Youtube.groovy by Petr Nejedly
 *
 * @author Erwin Bovendeur
 *
 */
class SnotrUrlExtractor extends FeedItemUrlExtractor {

	final VALID_FEED_URL = '^http://www.snotr.com/.*'
	final THUMB_URL = "http://s.mnstat.com/%s-small.jpg"
	final VIDEO_URL = "http://videos.snotr.com/%s.flv"

	String getExtractorName() {
		return getClass().getName();
	}

	boolean extractorMatches(URL feedUrl) {
		return feedUrl ==~ VALID_FEED_URL;
	}

	/* Quality is ignored on snotr */
	ContentURLContainer extractUrl(Map links, PreferredQuality requestedQuality) {
		def linkUrl = links.alternate != null ? links.alternate : links.default
		def linkParts = linkUrl.toString().split("/")
		def id = linkParts[linkParts.length - 2]
		def thumbUrl = String.format(THUMB_URL, id)
		def videoUrl = String.format(VIDEO_URL, id)

		log("Extract URL: " + linkUrl) 

		return new ContentURLContainer(fileType: MediaFileType.VIDEO, contentUrl: videoUrl, thumbnailUrl: thumbUrl)
	}

	/* Groovy test method */
	static void main(args) {
		SnotrUrlExtractor extractor = new SnotrUrlExtractor()

		assert extractor.extractorMatches( new URL("http://www.snotr.com/rss.xml"))

		Map links = ['default': new URL("http://www.snotr.com/video/7931/Balancing_Act")]
		ContentURLContainer result = extractor.extractUrl(links, PreferredQuality.MEDIUM)
		println "Result: $result"
	}
}

